#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
using SlimDX;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "S+H", Category = "Sync", Help = "Basic template with one transform in/out", Tags = "matrix")]
	#endregion PluginInfo
	public class SyncS_HNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", AutoValidate = false)]
		ISpread<double> FInput;

		[InputAttribute("Set", IsBang = true, IsSingle = true)]
		ISpread<bool> FSet;



		[Output("Output")]
		ISpread<double> FOutput;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FOutput.SliceCount = SpreadMax;
			if (this.FSet[0]) {
				FInput.Sync();
				for (int i = 0; i < SpreadMax; i++) {
					FOutput[i] = FInput[i];
				}

			}

		}
	}
}
